//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Security;
using System.Security.Permissions;
using System.IO;

namespace CLRUnleashed
{
	// Kod uruchomiony na komputerze otrzymuje domylnie ustawienia FullTrust.
	// Jeli zostanie to zmienione na Everything (wszystkie znane i wbudowane
	// uprawnienia), to wasne uprawienia zostan zignorowane. Oznacza to bdzie
	// powstanie wyjtku zabezpiecze.
	[CustomPermissionAttribute(SecurityAction.InheritanceDemand)]
	public class MyClass
	{
		public MyClass()
		{    
		}   

		public virtual void Message()
		{
			Console.WriteLine("To jest wiadomo z MyClass");
		}
	}
	public class YourClass : MyClass
	{
		public override void Message()
		{
			Console.WriteLine("To jest wiadomo z YourClass");
		}
	}
	/// <summary>
	/// Podsumowanie dla SecurityInheritance.
	/// </summary>
	class SecurityInheritance
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			CustomPermission perm = 
				new CustomPermission(PermissionState.Unrestricted);
			NamedPermissionSet pset = 
				new NamedPermissionSet("MyPermissionSet", PermissionState.None);
			pset.Description = "Zestaw uprawnie zawierajcy wasne uprawnienia";
			pset.AddPermission(perm);
			StreamWriter file = new StreamWriter("mypermissionset.xml");
			file.Write(pset.ToXml());
			file.Close();
			MyClass mc = new MyClass();
			mc.Message();
			YourClass yc = new YourClass();
			yc.Message();
		}
	}
}
